/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import java.util.Iterator;
import java.util.LinkedList;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.datatype.AbstractDataType;
import org.jaudiotagger.tag.datatype.ID3v2LyricLine;
import org.jaudiotagger.tag.datatype.Lyrics3TimeStamp;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;

public class Lyrics3Line
extends AbstractDataType {
    private LinkedList<Lyrics3TimeStamp> timeStamp = new LinkedList();
    private String lyric = "";

    public Lyrics3Line(String identifier, AbstractTagFrameBody frameBody) {
        super(identifier, frameBody);
    }

    public Lyrics3Line(Lyrics3Line copy) {
        super(copy);
        this.lyric = copy.lyric;
        for (int i = 0; i < copy.timeStamp.size(); ++i) {
            Lyrics3TimeStamp newTimeStamp = new Lyrics3TimeStamp(copy.timeStamp.get(i));
            this.timeStamp.add(newTimeStamp);
        }
    }

    public void setLyric(String lyric) {
        this.lyric = lyric;
    }

    public void setLyric(ID3v2LyricLine line) {
        this.lyric = line.getText();
    }

    public String getLyric() {
        return this.lyric;
    }

    @Override
    public int getSize() {
        int size = 0;
        for (Object e : this.timeStamp) {
            size += ((Lyrics3TimeStamp)e).getSize();
        }
        return size + this.lyric.length();
    }

    public void setTimeStamp(Lyrics3TimeStamp time) {
        this.timeStamp.clear();
        this.timeStamp.add(time);
    }

    public Iterator<Lyrics3TimeStamp> getTimeStamp() {
        return this.timeStamp.iterator();
    }

    public void addLyric(String newLyric) {
        this.lyric = this.lyric + newLyric;
    }

    public void addLyric(ID3v2LyricLine line) {
        this.lyric = this.lyric + line.getText();
    }

    public void addTimeStamp(Lyrics3TimeStamp time) {
        this.timeStamp.add(time);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Lyrics3Line)) {
            return false;
        }
        Lyrics3Line object = (Lyrics3Line)obj;
        if (!this.lyric.equals(object.lyric)) {
            return false;
        }
        return this.timeStamp.equals(object.timeStamp) && super.equals(obj);
    }

    public boolean hasTimeStamp() {
        return !this.timeStamp.isEmpty();
    }

    public void readString(String lineString, int offset) {
        if (lineString == null) {
            throw new NullPointerException("Image is null");
        }
        if (offset < 0 || offset >= lineString.length()) {
            throw new IndexOutOfBoundsException("Offset to line is out of bounds: offset = " + offset + ", line.length()" + lineString.length());
        }
        this.timeStamp = new LinkedList();
        int delim = lineString.indexOf("[", offset);
        while (delim >= 0) {
            offset = lineString.indexOf("]", delim) + 1;
            Lyrics3TimeStamp time = new Lyrics3TimeStamp("Time Stamp");
            time.readString(lineString.substring(delim, offset));
            this.timeStamp.add(time);
            delim = lineString.indexOf("[", offset);
        }
        this.lyric = lineString.substring(offset);
    }

    public String toString() {
        String str = "";
        for (Object e : this.timeStamp) {
            str = str + e.toString();
        }
        return "timeStamp = " + str + ", lyric = " + this.lyric + "\n";
    }

    public String writeString() {
        String str = "";
        for (Object e : this.timeStamp) {
            Lyrics3TimeStamp time = (Lyrics3TimeStamp)e;
            str = str + time.writeString();
        }
        return str + this.lyric;
    }

    @Override
    public void readByteArray(byte[] arr, int offset) throws InvalidDataTypeException {
        this.readString(arr.toString(), offset);
    }

    @Override
    public byte[] writeByteArray() {
        return Utils.getDefaultBytes(this.writeString(), "ISO8859-1");
    }
}

